/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.entities.BabySitter;
import OreSpawn.entities.Boyfriend;
import OreSpawn.entities.ChaosDemon;
import OreSpawn.entities.EntityLivingDragon;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Kraken;
import OreSpawn.entities.KrakenKing;
import OreSpawn.entities.Squid;
import OreSpawn.entities.SquidGuard;
import dangerzone.DangerZone;
import dangerzone.Effects;
import dangerzone.Explosion;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.TargetHelper;
import org.newdawn.slick.opengl.Texture;

public class PowerOrb
extends EntityLivingDragon {
    float myspeed = 0.0f;
    Texture texture2 = null;
    Texture texture3 = null;
    Texture texture4 = null;
    Texture texture5 = null;
    int lifetime;
    public Entity rider = null;
    public String ownername = null;

    public PowerOrb(World w) {
        super(w);
        this.maxrenderdist = 100;
        this.uniquename = "OreSpawn:PowerOrb";
        if (w != null) {
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(150);
        this.height = 0.95f;
        this.width = 0.95f;
        this.setMaxHealth(60.0f);
        this.setHealth(60.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(5.0f);
        this.searchDistance = 24.0f;
        this.attackRange = 1.5f;
        this.setCanDespawn(false);
        this.isImmuneToFire = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = false;
    }

    public void init() {
        super.init();
        this.lifetime = 300 + DangerZone.rand.nextInt(30);
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
    }

    public void doEntityAction(float deltaT) {
        --this.lifetime;
        if (this.lifetime <= 0) {
            this.deadflag = true;
            return;
        }
        ++this.searchcounter;
        if (this.searchcounter >= 12) {
            this.searchcounter = this.world.rand.nextInt(4);
            this.targetentity = this.findSomethingToAttack();
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + 1.0, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            Effects ef = null;
            float dmg = 200.0f;
            int dt = 4;
            int gb = this.getBID();
            if (gb == 1) {
                dmg = 100.0f;
                if (this.targetentity.getHealth() > 0.0f) {
                    this.targetentity.setHealth(this.targetentity.getHealth() * 9.0f / 10.0f);
                }
                ef = new Effects(6, 0.1f, 200);
            }
            if (gb == 2) {
                dmg = 50.0f;
                ef = new Effects(4, 2.0f, 100);
            }
            if (gb == 3) {
                dmg = 50.0f;
                ef = new Effects(4, 2.0f, 100);
            }
            if (gb == 4) {
                dmg = 50.0f;
                ef = new Effects(2, 2.0f, 100);
            }
            if (gb == 0) {
                Explosion.boom((Entity)(this.rider != null ? this.rider : this), (World)this.world, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz, (int)100, (boolean)true);
                if (this.targetentity.getHealth() > 0.0f) {
                    this.targetentity.setHealth(this.targetentity.getHealth() * 9.0f / 10.0f);
                }
                ef = new Effects(7, 2.0f, 200);
            }
            if (this.getIID() == -1) {
                dmg /= 4.0f;
            }
            if (this.getIID() == -2) {
                dmg /= 2.0f;
            }
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
            if (ef != null) {
                this.targetentity.addEffectFromServer(ef);
            }
            this.deadflag = true;
        }
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
    }

    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            int keep_trying = 15;
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0) {
                bid = 1;
                while (bid != 0 && keep_trying != 0) {
                    this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(35) - this.world.rand.nextInt(35)), this.posy + (double)(this.world.rand.nextInt(7) - 3), this.posz + (double)(this.world.rand.nextInt(35) - this.world.rand.nextInt(35)));
                    bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                    --keep_trying;
                }
                this.myspeed = 0.2f + this.world.rand.nextFloat() * 0.15f;
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
            }
            double dy = this.target.targety - this.posy;
            this.motiony += 0.12f * deltaT;
            if ((dy /= 20.0) > (double)0.2f) {
                dy = 0.2f;
            }
            if (dy < (double)-0.2f) {
                dy = -0.2f;
            }
            this.motiony = (float)((double)this.motiony + dy);
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float speedadjust = 1.0f;
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
            this.motionx *= 0.98f;
            this.motionz *= 0.98f;
        } else if (!this.world.isServer && this.world.rand.nextInt(20) == 1) {
            Utils.spawnParticles((World)this.world, (String)"DangerZone:ParticleSparkle", (int)2, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz, (boolean)false);
        }
        super.update(deltaT);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EntityLivingDragon) {
            return false;
        }
        if (e == this.rider) {
            return false;
        }
        if (this.ownername != null) {
            if (this.ownername.equals(e.getOwnerName())) {
                return false;
            }
            if (e instanceof Player) {
                Player ep = (Player)e;
                if (this.ownername.equals(ep.myname)) {
                    return false;
                }
            }
        }
        if (this.getIID() > 0) {
            if (e instanceof ChaosDemon) {
                return false;
            }
            if (e instanceof BabySitter) {
                return false;
            }
            if (e instanceof Squid) {
                return false;
            }
            if (e instanceof SquidGuard) {
                return false;
            }
            if (e instanceof Kraken) {
                return false;
            }
            if (e instanceof KrakenKing) {
                return false;
            }
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Girlfriend && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Boyfriend && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        int gb;
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/PowerOrbWhitetexture.png");
            this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/PowerOrbPurpletexture.png");
            this.texture3 = TextureMapper.getTexture((String)"orespawnres/skins/PowerOrbRedtexture.png");
            this.texture4 = TextureMapper.getTexture((String)"orespawnres/skins/PowerOrbGreentexture.png");
            this.texture5 = TextureMapper.getTexture((String)"orespawnres/skins/PowerOrbBluetexture.png");
        }
        if ((gb = this.getBID()) == 0) {
            return this.texture;
        }
        if (gb == 1) {
            return this.texture2;
        }
        if (gb == 2) {
            return this.texture3;
        }
        if (gb == 3) {
            return this.texture4;
        }
        return this.texture5;
    }

    public String getHurtSound() {
        return null;
    }

    public String getDeathSound() {
        return null;
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        return "OreSpawn:kyuubi_living";
    }
}

